/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import jclass.bwt.ArrowButtonConverter;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCButton;
import jclass.bwt.Shadow;
import jclass.util.JCEnvironment;

public class JCArrowButton
extends JCButton
implements Runnable {
    public static final int UP = 10;
    public static final int DOWN = 9;
    public static final int LEFT = 0;
    public static final int RIGHT = 2;
    int orientation = 9;
    Dimension arrow_size;
    int initial_delay = Integer.MAX_VALUE;
    transient Thread thread;
    Color border_color;
    Color right_border_color;
    boolean bg_set = false;
    private static final String base = "arrowbutton";
    private static int nameCounter;

    public JCArrowButton() {
        this(9, (Applet)null, (String)null);
    }

    public JCArrowButton(int n) {
        this(n, (Applet)null, (String)null);
    }

    public JCArrowButton(int n, Applet applet, String string) {
        super(null, applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.highlight = 0;
        this.shadow = 1;
        if (this.getClass().getName().equals("jclass.bwt.JCArrowButton")) {
            this.getParameters(applet);
        }
        this.setOrientation(n);
        if (JCEnvironment.getJavaVersion() >= 110) {
            this.traversable = false;
        }
        this.double_buffer = false;
    }

    protected void getParameters() {
        super.getParameters();
        ArrowButtonConverter.getParams(this);
    }

    public synchronized void setBackground(Color color) {
        this.bg_set = true;
        super.setBackground(color);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public synchronized void setOrientation(int n) {
        ArrowButtonConverter.checkOrientation(n);
        this.orientation = n;
        if (n == 10 || n == 9) {
            this.insets = new Insets(3, 2, 3, 3);
            this.arrow_size = new Dimension(7, 4);
        } else {
            this.arrow_size = new Dimension(4, 7);
            this.insets = new Insets(2, 3, 3, 3);
        }
        this.repaint();
    }

    public Dimension getArrowSize() {
        return this.arrow_size;
    }

    public synchronized void setArrowSize(Dimension dimension) {
        this.arrow_size = dimension;
        this.repaint();
    }

    public int getInitialRepeatDelay() {
        return this.initial_delay;
    }

    public void setInitialRepeatDelay(int n) {
        this.initial_delay = n;
    }

    protected int preferredWidth() {
        return this.arrow_size.width;
    }

    protected int preferredHeight() {
        return this.arrow_size.height;
    }

    protected void drawHighlight(Graphics graphics, boolean bl) {
    }

    protected void drawShadow(Graphics graphics) {
        super.drawShadow(graphics);
        if (this.border_color != null) {
            graphics.setColor(this.border_color);
            graphics.drawRect(0, 0, this.size().width - 1, this.size().height - 1);
        }
        if (this.right_border_color != null) {
            Shadow.drawBottomLines(graphics, 1, 0, 0, this.size().width, this.size().height, this.right_border_color);
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (!this.bg_set) {
            this.setBackground(this.getParent().getBackground());
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        Rectangle rectangle = this.getDrawingArea();
        switch (this.orientation) {
            case 10: {
                nArray[0] = this.arrow_size.width / 2;
                nArray2[0] = 0;
                nArray[1] = 0;
                nArray2[1] = this.arrow_size.height - 1;
                nArray[2] = this.arrow_size.width - 1;
                nArray2[2] = this.arrow_size.height - 1;
                break;
            }
            case 9: {
                nArray[0] = this.arrow_size.width / 2;
                nArray2[0] = this.arrow_size.height - 1;
                nArray[1] = 0;
                nArray[2] = this.arrow_size.width - 1;
                nArray2[2] = 0;
                nArray2[1] = 0;
                break;
            }
            case 0: {
                nArray2[0] = this.arrow_size.height / 2;
                nArray[0] = 0;
                nArray2[1] = 0;
                nArray2[2] = this.arrow_size.height - 1;
                nArray[1] = nArray[2] = this.arrow_size.width - 1;
                break;
            }
            case 2: {
                nArray[0] = this.arrow_size.width - 1;
                nArray2[0] = this.arrow_size.height / 2;
                nArray[2] = 0;
                nArray[1] = 0;
                nArray2[1] = 0;
                nArray2[2] = this.arrow_size.height - 1;
                break;
            }
        }
        int n = (rectangle.width - this.arrow_size.width) / 2;
        int n2 = (rectangle.height - this.arrow_size.height) / 2;
        int n3 = 0;
        while (n3 < 3) {
            int n4 = n3;
            nArray[n4] = nArray[n4] + (rectangle.x + n);
            int n5 = n3++;
            nArray2[n5] = nArray2[n5] + (rectangle.y + n2);
        }
        if (this.armed) {
            graphics.translate(this.arm_offset, this.arm_offset);
        }
        if (!this.isEnabled()) {
            graphics.setColor(Color.lightGray.darker());
        }
        if (this.orientation == 10 || this.orientation == 9) {
            int n6 = nArray[0];
            int n7 = nArray[0];
            int n8 = nArray2[0];
            double d = nArray2[1] != nArray2[0] ? (double)(nArray[1] - nArray[0]) / (double)(nArray2[1] - nArray2[0]) : 0.0;
            double d2 = nArray2[2] != nArray2[0] ? (double)(nArray[2] - nArray[0]) / (double)(nArray2[2] - nArray2[0]) : 0.0;
            while (true) {
                graphics.drawLine(n6, n8, n7, n8);
                if (!(nArray2[1] > nArray2[0] ? ++n8 > nArray2[1] : --n8 < nArray2[1])) {
                    n6 = (int)((double)(n8 - nArray2[0]) * d + (double)nArray[0]);
                    n7 = (int)((double)(n8 - nArray2[0]) * d2 + (double)nArray[0]);
                    continue;
                }
                break;
            }
        } else {
            int n9 = nArray2[0];
            int n10 = nArray2[0];
            int n11 = nArray[0];
            double d = nArray[1] != nArray[0] ? (double)(nArray2[1] - nArray2[0]) / (double)(nArray[1] - nArray[0]) : 0.0;
            double d3 = nArray[2] != nArray[0] ? (double)(nArray2[2] - nArray2[0]) / (double)(nArray[2] - nArray[0]) : 0.0;
            while (true) {
                graphics.drawLine(n11, n9, n11, n10);
                if (nArray[1] > nArray[0] ? ++n11 > nArray[1] : --n11 < nArray[1]) break;
                n9 = (int)((double)(n11 - nArray[0]) * d + (double)nArray2[0]);
                n10 = (int)((double)(n11 - nArray[0]) * d3 + (double)nArray2[0]);
            }
        }
        graphics.translate(-this.arm_offset, -this.arm_offset);
    }

    public void getDrawingArea(Rectangle rectangle) {
        int n = this.highlight + this.shadow;
        rectangle.reshape(n, n, Math.max(0, this.size().width - 2 * n), Math.max(0, this.size().height - 2 * n));
    }

    public synchronized void disable() {
        if (this.isEnabled() && this.thread != null) {
            this.disarmAction(null);
        }
        super.disable();
    }

    public void armAction(Event event) {
        super.armAction(event);
        if (this.initial_delay != Integer.MAX_VALUE) {
            this.thread = new Thread((Runnable)this, this.getName());
            this.thread.setPriority(1);
            this.thread.start();
        }
    }

    public void disarmAction(Event event) {
        if (this.thread != null) {
            Thread.yield();
            this.thread.stop();
            this.thread = null;
        }
        super.disarmAction(event);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        super.mouseUp(event, n, n2);
        return !BWTUtil.instanceOf(this.getParent(), "JCScrollbar");
    }

    public void run() {
        int n = this.initial_delay;
        while (true) {
            long l = System.currentTimeMillis();
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {}
            if (!Thread.currentThread().isAlive() || this.thread == null) {
                return;
            }
            if (System.currentTimeMillis() - l >= (long)n) {
                this.clickAction(null);
            }
            n = 50;
        }
    }
}

